/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.gui.util;

import com.mojang.blaze3d.vertex.PoseStack;
import fudge.notenoughcrashes.gui.util.Widget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextWidget
implements Widget {
    private final Component text;
    private final String translated;
    private final int color;
    private final Font font;
    private final int x;
    private final int y;
    private final int width;
    final int startX;
    public static final int CLICKABLE_TEXT_COLOR = 0xE0E000;

    public TextWidget(Component text, int color, Font font, int x, int y) {
        this.text = text;
        this.color = color;
        this.font = font;
        this.x = x;
        this.y = y;
        this.translated = text.getString();
        this.width = Minecraft.m_91087_().f_91062_.m_92895_(this.translated);
        this.startX = x - this.width / 2;
    }

    @Override
    public void draw(PoseStack stack) {
        GuiComponent.m_93208_((PoseStack)stack, (Font)this.font, (String)this.translated, (int)this.x, (int)this.y, (int)this.color);
    }

    @Override
    public void onClick(double x, double y) {
        Screen screen;
        Component hoveredText = this.getTextAt(x, y);
        if (hoveredText != null && (screen = Minecraft.m_91087_().f_91080_) != null) {
            screen.m_5561_(hoveredText.m_7383_());
        }
    }

    private boolean isWithinBounds(double mouseX, double mouseY) {
        int endX = this.x + this.width / 2;
        int height = 8;
        int startY = this.y - height / 2;
        int endY = this.y + height / 2;
        return mouseX >= (double)this.startX && mouseX <= (double)endX && mouseY <= (double)endY && mouseY >= (double)startY;
    }

    private Component getTextAt(double x, double y) {
        if (this.isWithinBounds(x, y)) {
            int i = this.startX;
            Font renderer = Minecraft.m_91087_().f_91062_;
            for (Component component : this.getTextParts(this.text)) {
                if (!((double)(i += renderer.m_92895_(component.m_6111_())) > x)) continue;
                return component;
            }
        }
        return null;
    }

    private List<Component> getTextParts(Component text) {
        ArrayList<Component> parts = new ArrayList<Component>();
        parts.add(text);
        parts.addAll(text.m_7360_());
        return parts;
    }
}

